## Cell Properties

Cell properties are defining some meta-information attached to measures and calculated members/measures.




### Description

In MDX a cell can define not only a value (e.g., string, numerical value) but a list of predefined properties.

|Name|Description|Read Only|
|-|-|-|
|ACTION_TYPE                                                            |||
|[ASSOCIATED_MEASURE_GROUP](cellProperties/ASSOCIATED_MEASURE_GROUP.md) | defines the measure group a calculated measure is attached to.||
|BACK_COLOR                                                             |||
|[CAPTION](cellProperties/CAPTION.md)                                   | defines the caption of a calculated member.||
|CELL_ORDINAL                                                           ||yes|
[CLASSNAME](cellProperties/CLASSNAME.md)                                | defines HML/CSS properties to be used for cell rendering.||
|[DESCRIPTION](cellProperties/DESCRIPTION.md)                           | defines the description of a calculated member.||
|[DISPLAY_FOLDER](cellProperties/DISPLAY_FOLDER.md)                     | defines the location (path) of a calculated measure.||
|FONT_FLAGS                                                             |||
|FONT_NAME                                                              |||
|FONT_SIZE                                                              |||
|FORE_COLOR                                                             |||
|[FORMAT_STRING](cellProperties/FORMAT_STRING.md)                       | controls how cell values are formatted.||
|FORMATTED_VALUE                                                        ||yes|
|[LANGUAGE](cellProperties/LANGUAGE.md)                                 | controls how cell formatted values are localized.||
|UPDATEABLE                                                             |||
|[NON_EMPTY_BEHAVIOR](cellProperties/NON_EMPTY_BEHAVIOR.md)             | defines the non empty behavior of a calculated measure.||
[REQUEST_CACHED](cellProperties/REQUEST_CACHED.md)                      | controls how tuple values are cached.||
|[SOLVE_ORDER](cellProperties/SOLVE_ORDER.md)                           | controls the order of evaluation of calculated members.||
[STYLE](cellProperties/STYLE.md)                                        | defines HML/CSS properties to be used for cell rendering.||
|VALUE                                                                  ||yes|
|[VISIBLE](cellProperties/VISIBLE.md)                                   | controls the visibility of a calculated member.||



                                                                      

### See Also


[Calculated Members](Calculated%20Members.md)

[Dimension Properties](Dimension%20Properties.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
